% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getdata.R
\name{getdata}
\alias{getdata}
\title{Downloads and processes the data from the API}
\usage{
getdata(origin, destination, year, classification, write, wrapper)
}
\arguments{
\item{origin}{ISO code for country of origin (e.g. \code{chl} for Chile). Run \code{countries_list} in case of doubt.}

\item{destination}{ISO code for country of destination (e.g. \code{chn} for China). Run \code{countries_list} in case of doubt.}

\item{year}{The OEC's API ranges from 1962 to 2016}

\item{classification}{Trade classification that can be \code{1} (HS92 4 characters since year 1995), 
\code{2} (SITC rev.2 4 characters since year 1962) or 
\code{3} (HS92 6 characters since year 1995). By default set to \code{1}.}

\item{write}{Write to user's filespace (by default set to \code{FALSE})}

\item{wrapper}{Argument used by \code{getdata_interval} (by default set to \code{FALSE})}
}
\description{
Downloads and processes the data from the API
}
\examples{
\dontrun{
# Run `countries_list` to display the full list of countries
# What does Chile export to China?  year 2015 - classification HS92 6 characters
getdata("chl", "chn", 2015, 3)
}

}
\keyword{functions}
