% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ppt_ph_manipulate.R
\name{ph_add_fpar}
\alias{ph_add_fpar}
\title{append fpar}
\usage{
ph_add_fpar(
  x,
  value,
  type = "body",
  id = 1,
  id_chr = NULL,
  ph_label = NULL,
  level = 1,
  par_default = TRUE
)
}
\arguments{
\item{x}{an rpptx object}

\item{value}{fpar object}

\item{type}{placeholder type}

\item{id}{placeholder index (integer) for a duplicated type. This is to be used when a placeholder
type is not unique in the layout of the current slide, e.g. two placeholders with type 'body'. To
add onto the first, use \code{id = 1} and \code{id = 2} for the second one.
Values can be read from \code{\link{slide_summary}}.}

\item{id_chr}{deprecated.}

\item{ph_label}{label associated to the placeholder. Use column
\code{ph_label} of result returned by \code{\link{slide_summary}}.}

\item{level}{paragraph level}

\item{par_default}{specify if the default paragraph formatting
should be used.}
}
\description{
append \code{fpar} (a formatted paragraph) in a placeholder
The function let you add a new formatted paragraph (\code{\link{fpar}})
to an existing content in an exiisting shape, existing paragraphs
will be preserved.
}
\note{
This function will be deprecated in a next release because it is not
efficient and make users write complex code. Use instead \code{\link[=fpar]{fpar()}} to build
formatted paragraphs.
}
\section{Usage}{

If your goal is to add formatted text in a new shape, use \code{\link{ph_with}}
with a \code{\link{block_list}} instead of this function.
}

\examples{
bold_face <- shortcuts$fp_bold(font.size = 30)
bold_redface <- update(bold_face, color = "red")

fpar_ <- fpar(ftext("Hello ", prop = bold_face),
              ftext("World", prop = bold_redface ),
              ftext(", how are you?", prop = bold_face ) )

doc <- read_pptx()
doc <- add_slide(doc, layout = "Title and Content", master = "Office Theme")
doc <- ph_with(doc, "", location = ph_location(bg = "wheat", newlabel = "myph"))
doc <- ph_add_fpar(doc, value = fpar_, ph_label = "myph", level = 2)

print(doc, target = tempfile(fileext = ".pptx"))
}
\seealso{
\code{\link{fpar}}
}
