% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ols-information-criteria.R
\name{ols_sbic}
\alias{ols_sbic}
\title{Sawa's bayesian information criterion}
\usage{
ols_sbic(model, full_model)
}
\arguments{
\item{model}{An object of class \code{lm}.}

\item{full_model}{An object of class \code{lm}.}
}
\value{
Sawa's Bayesian Information Criterion
}
\description{
Sawa's bayesian information criterion for model selection.
}
\details{
Sawa (1978) developed a model selection criterion that was derived from a
Bayesian modification of the AIC criterion. Sawa's Bayesian Information
Criterion (BIC) is a function of the number of observations n, the SSE, the
pure error variance fitting the full model, and the number of independent
variables including the intercept.

\deqn{SBIC = n * ln(SSE / n) + 2(p + 2)q - 2(q^2)}

where \eqn{q = n(\sigma^2)/SSE}, \emph{n} is the sample size, \emph{p} is the number of model parameters including intercept
\emph{SSE} is the residual sum of squares.
}
\examples{
full_model <- lm(mpg ~ ., data = mtcars)
model <- lm(mpg ~ disp + hp + wt + qsec, data = mtcars)
ols_sbic(model, full_model)

}
\references{
Sawa, T. (1978). “Information Criteria for Discriminating among Alternative Regression Models.” Econometrica
46:1273–1282.

Judge, G. G., Griffiths, W. E., Hill, R. C., and Lee, T.-C. (1980). The Theory and Practice of Econometrics.
New York: John Wiley & Sons.
}
\seealso{
Other model selection criteria: \code{\link{ols_aic}},
  \code{\link{ols_apc}}, \code{\link{ols_fpe}},
  \code{\link{ols_hsp}}, \code{\link{ols_mallows_cp}},
  \code{\link{ols_msep}}, \code{\link{ols_sbc}}
}
\concept{model selection criteria}
