% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict-truncmodel.R
\name{predict.truncmodel}
\alias{predict.truncmodel}
\title{Predicted Expected Response for One-Inflated or Truncated Models}
\usage{
\method{predict}{truncmodel}(object, ...)
}
\arguments{
\item{object}{An object of class \code{truncmodel}}

\item{...}{Additional argument \code{df}, a data frame used to calculate the expected
value of the response variable.}
}
\value{
A numeric vector of predicted expected responses for the observations in \code{df}.
}
\description{
Calculates the predicted expected response for a model fitted using
\code{\link{oneinfl}} or \code{\link{truncreg}}.
}
\details{
This function computes the expected response based on the fitted model. The computation
differs depending on the distribution. For \code{Poisson (PP)}, predicted values are computed
using \code{\link{E_pois_noinfl}}. For \code{Negative Binomial (ZTNB)}, predicted values are
computed using \code{\link{E_negbin_noinfl}}.
}
\examples{
# Example usage
df <- data.frame(x = rnorm(100), y = rpois(100, lambda = 5))
model <- truncreg(y ~ x, df = df, dist = "Poisson")
predict(model, df = df)

}
\seealso{
\code{\link{oneinfl}} for fitting one-inflated models.
\code{\link{truncreg}} for fitting truncated models.
\code{\link{E_pois_noinfl}}, \code{\link{E_negbin_noinfl}} for the expected value calculations.
}
