% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract.R
\name{Extract}
\alias{Extract}
\alias{$.ClassGenerator}
\alias{[[.ClassGenerator}
\alias{$<-.ClassGenerator}
\alias{[[<-.ClassGenerator}
\alias{$.Instance}
\alias{[[.Instance}
\title{Extract or Replace Parts of a Class or Instance}
\usage{
\method{$}{ClassGenerator}(x, name)

\method{[[}{ClassGenerator}(x, i, exact = TRUE, inherits = TRUE)

\method{$}{ClassGenerator}(x, name) <- value

\method{[[}{ClassGenerator}(x, name) <- value

\method{$}{Instance}(x, name)

\method{[[}{Instance}(x, i, exact = TRUE, inherits = TRUE)
}
\arguments{
\item{x}{object of class \code{"Instance"} or \code{"ClassGenerator"}}

\item{i, name}{character or symbol for \code{`$`} describing field name to return or set}

\item{exact}{logical controlling whether a partial match is acceptable. Defaults to \code{TRUE} for no partial matching}

\item{inherits}{logical describing whether parent environments should be searched}

\item{value}{new field value}
}
\value{
Environment of class \code{"Instance"} or function of class \code{"ClassGenerator"}
}
\description{
Operators acting on \code{\link{oClass}} generators and their instances.
}
\details{
For \code{\link{oClass}} instances, \code{`$`} and \code{`[`} first search the instance environment for the object.
If no object is found, then all inherited objects are searched in order. Any object assigned to the instance
will be inserted into the instance's environment. These operators act on the underlying Class template environment
when applied to a Class generator.
}
