% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/alter.R
\name{change_inherit}
\alias{change_inherit}
\title{Change the Inheritance of an oClass}
\usage{
change_inherit(x, parent)
}
\arguments{
\item{x}{oClass generator function}

\item{parent}{oClass generator function from which \code{x} inherits}
}
\value{
oClass generator function
}
\description{
This function takes twos \code{\link{oClass}} generator function and alters the first
so that it inherits the template and classes of the second. Existing instances will
inherit the objects contained in the new parent, but will not gain access to the S3
methods.
}
\examples{
typist <- oClass("typist")
job    <- oClass("job", hours = 40, pay=15)

typist <- change_inherit(typist, job)
typist$hours
}
