% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opal.session.R
\name{opal.session_delete}
\alias{opal.session_delete}
\title{Delete the R session}
\usage{
opal.session_delete(opal)
}
\arguments{
\item{opal}{Opal object.}
}
\description{
Delete the remote R session. Ignored if the session does not exist.
}
\examples{
\dontrun{
o <- opal.login('administrator','password', url='https://opal-demo.obiba.org')
opal.session(o)
opal.session_exists(o)
opal.session_delete(o)
opal.logout(o)
}
}
\seealso{
Other session functions: 
\code{\link{opal.session}()},
\code{\link{opal.session_events}()},
\code{\link{opal.session_exists}()},
\code{\link{opal.session_get}()},
\code{\link{opal.session_running}()}
}
\concept{session functions}
