% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_posteriorCalcs.R
\name{Qn}
\alias{Qn}
\title{Calculate Qn}
\usage{
Qn(theta_hat, N, E)
}
\arguments{
\item{theta_hat}{A numeric vector of hyperparameter estimates (likely from
\code{\link{autoHyper}} or from directly minimizing
\code{\link{negLLsquash}}) ordered as:
\eqn{\alpha_1, \beta_1, \alpha_2, \beta_2, P}.}

\item{N}{A whole number vector of actual counts from
\code{\link{processRaw}}.}

\item{E}{A numeric vector of expected counts from \code{\link{processRaw}}.}
}
\value{
A numeric vector of probabilities.
}
\description{
\code{Qn} calculates \eqn{Q_n}, the posterior probability that \eqn{\lambda}
came from the first component of the mixture, given \emph{N = n} (Eq. 6,
DuMouchel 1999). \eqn{Q_n} is the mixture fraction for the posterior
distribution.
}
\details{
The hyperparameter estimates (\code{theta_hat}) are:
  \itemize{
    \item{\eqn{\alpha_1, \beta_1}: }{Parameter estimates of the first
      component of the prior distribution}
    \item{\eqn{\alpha_2, \beta_2}: }{Parameter estimates of the second
      component}
    \item{\eqn{P}: }{Mixture fraction estimate of the prior distribution}
}
}
\examples{
theta_init <- data.frame(
  alpha1 = c(0.2, 0.1),
  beta1  = c(0.1, 0.1),
  alpha2 = c(2,   10),
  beta2  = c(4,   10),
  p      = c(1/3, 0.2)
)
data(caers)
proc <- processRaw(caers)
squashed <- squashData(proc, bin_size = 100, keep_pts = 100)
squashed <- squashData(squashed, count = 2, bin_size = 10, keep_pts = 20)
suppressWarnings(
  theta_hat <- autoHyper(data = squashed, theta_init = theta_init)$estimates
)
qn <- Qn(theta_hat, N = proc$N, E = proc$E)
head(qn)

}
\references{
DuMouchel W (1999). "Bayesian Data Mining in Large Frequency
  Tables, With an Application to the FDA Spontaneous Reporting System."
  \emph{The American Statistician}, 53(3), 177-190.
}
\seealso{
\code{\link{autoHyper}},  \code{\link{exploreHypers}},
  \code{\link{negLLsquash}}, \code{\link{negLL}},
  \code{\link{negLLzero}}, and \code{\link{negLLzeroSquash}} for
  hyperparameter estimation.

\code{\link{processRaw}} for finding counts.

Other posterior distribution functions: 
\code{\link{ebgm}()},
\code{\link{quantBisect}()}
}
\concept{posterior distribution functions}
\keyword{openEBGM}
