/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.coref.resolver;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import opennlp.tools.coref.DiscourseEntity;
import opennlp.tools.coref.Linker;
import opennlp.tools.coref.mention.MentionContext;
import opennlp.tools.coref.resolver.MaxentResolver;
import opennlp.tools.coref.resolver.NonReferentialResolver;
import opennlp.tools.coref.resolver.ResolverMode;

public class PluralPronounResolver
extends MaxentResolver {
    int NUM_SENTS_BACK_PRONOUNS = 2;

    public PluralPronounResolver(String projectName, ResolverMode m) throws IOException {
        super(projectName, "tmodel", m, 30);
    }

    public PluralPronounResolver(String projectName, ResolverMode m, NonReferentialResolver nrr) throws IOException {
        super(projectName, "tmodel", m, 30, nrr);
    }

    protected List getFeatures(MentionContext mention, DiscourseEntity entity) {
        ArrayList<String> features = new ArrayList<String>();
        features.addAll(super.getFeatures(mention, entity));
        if (entity != null) {
            features.addAll(this.getPronounMatchFeatures(mention, entity));
            MentionContext cec = entity.getLastExtent();
            features.addAll(this.getDistanceFeatures(mention, entity));
            features.addAll(PluralPronounResolver.getContextFeatures(cec));
            features.add(this.getMentionCountFeature(entity));
        }
        return features;
    }

    protected boolean outOfRange(MentionContext mention, DiscourseEntity entity) {
        MentionContext cec = entity.getLastExtent();
        return mention.getSentenceNumber() - cec.getSentenceNumber() > this.NUM_SENTS_BACK_PRONOUNS;
    }

    public boolean canResolve(MentionContext mention) {
        String tag = mention.getHeadTokenTag();
        return tag != null && tag.startsWith("PRP") && Linker.pluralThirdPersonPronounPattern.matcher(mention.getHeadTokenText()).matches();
    }
}

