/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.lang.english;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import opennlp.tools.parser.Parse;

public class HeadRules
implements opennlp.tools.parser.HeadRules {
    private Map headRules;
    private Set punctSet;

    public HeadRules(String ruleDir) throws IOException {
        this.readHeadRules(ruleDir);
        this.punctSet = new HashSet();
        this.punctSet = new HashSet();
        this.punctSet.add(".");
        this.punctSet.add(",");
        this.punctSet.add("``");
        this.punctSet.add("''");
    }

    public HeadRules(Map ruleMap) {
        this.headRules = ruleMap;
    }

    public Set getPunctuationTags() {
        return this.punctSet;
    }

    public Parse getHead(Parse[] constituents, String type) {
        if (constituents[0].getType() == "TK") {
            return null;
        }
        if (type.equals("NP") || type.equals("NX")) {
            int ci;
            String[] tags1 = new String[]{"NN", "NNP", "NNPS", "NNS", "NX", "JJR", "POS"};
            for (ci = constituents.length - 1; ci >= 0; --ci) {
                for (int ti = tags1.length - 1; ti >= 0; --ti) {
                    if (!constituents[ci].getType().equals(tags1[ti])) continue;
                    return constituents[ci].getHead();
                }
            }
            for (ci = 0; ci < constituents.length; ++ci) {
                if (!constituents[ci].getType().equals("NP")) continue;
                return constituents[ci].getHead();
            }
            String[] tags2 = new String[]{"$", "ADJP", "PRN"};
            for (int ci2 = constituents.length - 1; ci2 >= 0; --ci2) {
                for (int ti = tags2.length - 1; ti >= 0; --ti) {
                    if (!constituents[ci2].getType().equals(tags2[ti])) continue;
                    return constituents[ci2].getHead();
                }
            }
            String[] tags3 = new String[]{"JJ", "JJS", "RB", "QP"};
            for (int ci3 = constituents.length - 1; ci3 >= 0; --ci3) {
                for (int ti = tags3.length - 1; ti >= 0; --ti) {
                    if (!constituents[ci3].getType().equals(tags3[ti])) continue;
                    return constituents[ci3].getHead();
                }
            }
            return constituents[constituents.length - 1].getHead();
        }
        HeadRule hr = (HeadRule)this.headRules.get(type);
        if (hr != null) {
            String[] tags = hr.tags;
            int cl = constituents.length;
            int tl = tags.length;
            if (hr.leftToRight) {
                for (int ti = 0; ti < tl; ++ti) {
                    for (int ci = 0; ci < cl; ++ci) {
                        if (!constituents[ci].getType().equals(tags[ti])) continue;
                        return constituents[ci].getHead();
                    }
                }
                return constituents[0].getHead();
            }
            for (int ti = 0; ti < tl; ++ti) {
                for (int ci = cl - 1; ci >= 0; --ci) {
                    if (!constituents[ci].getType().equals(tags[ti])) continue;
                    return constituents[ci].getHead();
                }
            }
            return constituents[cl - 1].getHead();
        }
        return constituents[constituents.length - 1].getHead();
    }

    private void readHeadRules(String file) throws IOException {
        String line;
        BufferedReader str = new BufferedReader(new FileReader(file));
        this.headRules = new HashMap(30);
        while ((line = str.readLine()) != null) {
            StringTokenizer st = new StringTokenizer(line);
            String num = st.nextToken();
            String type = st.nextToken();
            String dir = st.nextToken();
            String[] tags = new String[Integer.parseInt(num)];
            int ti = 0;
            while (st.hasMoreTokens()) {
                tags[ti] = st.nextToken();
                ++ti;
            }
            this.headRules.put(type, new HeadRule(dir.equals("1"), tags));
        }
    }

    private static class HeadRule {
        public boolean leftToRight;
        public String[] tags;

        public HeadRule(boolean l2r, String[] tags) {
            this.leftToRight = l2r;
            this.tags = tags;
        }
    }
}

