/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.tokenize;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import opennlp.tools.tokenize.AbstractTokenizer;
import opennlp.tools.tokenize.CharacterEnum;
import opennlp.tools.util.Span;

public class SimpleTokenizer
extends AbstractTokenizer {
    public Span[] tokenizePos(String s) {
        CharacterEnum charType;
        CharacterEnum state = charType = CharacterEnum.WHITESPACE;
        ArrayList<Span> tokens = new ArrayList<Span>();
        int sl = s.length();
        int start = -1;
        char pc = '\u0000';
        for (int ci = 0; ci < sl; ++ci) {
            char c = s.charAt(ci);
            charType = Character.isWhitespace(c) ? CharacterEnum.WHITESPACE : (Character.isLetter(c) ? CharacterEnum.ALPHABETIC : (Character.isDigit(c) ? CharacterEnum.NUMERIC : CharacterEnum.OTHER));
            if (state == CharacterEnum.WHITESPACE) {
                if (charType != CharacterEnum.WHITESPACE) {
                    start = ci;
                }
            } else if (charType != state || charType == CharacterEnum.OTHER && c != pc) {
                tokens.add(new Span(start, ci));
                start = ci;
            }
            state = charType;
            pc = c;
        }
        if (charType != CharacterEnum.WHITESPACE) {
            tokens.add(new Span(start, sl));
        }
        return tokens.toArray(new Span[tokens.size()]);
    }

    public static void main(String[] args) throws IOException {
        if (args.length != 0) {
            System.err.println("Usage:  java opennlp.tools.tokenize.SimpleTokenizer < sentences");
            System.exit(1);
        }
        SimpleTokenizer tokenizer = new SimpleTokenizer();
        BufferedReader inReader = new BufferedReader(new InputStreamReader(System.in));
        String line = inReader.readLine();
        while (line != null) {
            if (line.equals("")) {
                System.out.println();
            } else {
                String[] tokens = tokenizer.tokenize(line);
                if (tokens.length > 0) {
                    System.out.print(tokens[0]);
                }
                int tn = tokens.length;
                for (int ti = 1; ti < tn; ++ti) {
                    System.out.print(" " + tokens[ti]);
                }
                System.out.println();
            }
            line = inReader.readLine();
        }
    }
}

