/*
 * Decompiled with CFR 0.152.
 */
package opennlp.maxent;

import java.io.IOException;
import junit.framework.TestCase;
import opennlp.maxent.FileEventStream;
import opennlp.maxent.GIS;
import opennlp.maxent.GISModel;
import opennlp.maxent.OnePassRealValueDataIndexer;
import opennlp.maxent.RealValueFileEventStream;

public class RealValueModelTests
extends TestCase {
    public void testRealValuedWeightsVsRepeatWeighting() throws IOException {
        RealValueFileEventStream rvfes1 = new RealValueFileEventStream("test/data/opennlp/maxent/real-valued-weights-training-data.txt");
        GISModel realModel = GIS.trainModel(100, new OnePassRealValueDataIndexer(rvfes1, 1));
        FileEventStream rvfes2 = new FileEventStream("test/data/opennlp/maxent/repeat-weighting-training-data.txt");
        GISModel repeatModel = GIS.trainModel(100, new OnePassRealValueDataIndexer(rvfes2, 1));
        String[] features2Classify = new String[]{"feature2", "feature5"};
        double[] realResults = realModel.eval(features2Classify);
        double[] repeatResults = repeatModel.eval(features2Classify);
        RealValueModelTests.assertEquals((int)realResults.length, (int)repeatResults.length);
        int i = 0;
        while (i < realResults.length) {
            RealValueModelTests.assertEquals((double)realResults[i], (double)repeatResults[i], (double)0.01f);
            System.out.println(String.format("classifiy with realModel: %1$s = %2$f", realModel.getOutcome(i), realResults[i]));
            System.out.println(String.format("classifiy with repeatModel: %1$s = %2$f", repeatModel.getOutcome(i), repeatResults[i]));
            ++i;
        }
        features2Classify = new String[]{"feature1", "feature2", "feature3", "feature4", "feature5"};
        realResults = realModel.eval(features2Classify, new float[]{5.5f, 6.1f, 9.1f, 4.0f, 1.8f});
        repeatResults = repeatModel.eval(features2Classify, new float[]{5.5f, 6.1f, 9.1f, 4.0f, 1.8f});
        System.out.println();
        RealValueModelTests.assertEquals((int)realResults.length, (int)repeatResults.length);
        i = 0;
        while (i < realResults.length) {
            RealValueModelTests.assertEquals((double)realResults[i], (double)repeatResults[i], (double)0.01f);
            System.out.println(String.format("classifiy with realModel: %1$s = %2$f", realModel.getOutcome(i), realResults[i]));
            System.out.println(String.format("classifiy with repeatModel: %1$s = %2$f", repeatModel.getOutcome(i), repeatResults[i]));
            ++i;
        }
    }
}

