/*
 * Decompiled with CFR 0.152.
 */
package opennlp.maxent.io;

import gnu.trove.TObjectIntHashMap;
import gnu.trove.TObjectIntProcedure;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import opennlp.maxent.ComparablePredicate;
import opennlp.maxent.Context;
import opennlp.maxent.GISModel;

public abstract class GISModelWriter {
    protected Context[] PARAMS;
    protected String[] OUTCOME_LABELS;
    protected int CORRECTION_CONSTANT;
    protected double CORRECTION_PARAM;
    protected String[] PRED_LABELS;

    public GISModelWriter(GISModel model) {
        Object[] data = model.getDataStructures();
        this.PARAMS = (Context[])data[0];
        TObjectIntHashMap pmap = (TObjectIntHashMap)data[1];
        this.OUTCOME_LABELS = (String[])data[2];
        this.CORRECTION_CONSTANT = (Integer)data[3];
        this.CORRECTION_PARAM = (Double)data[4];
        this.PRED_LABELS = new String[pmap.size()];
        pmap.forEachEntry(new TObjectIntProcedure(){

            public boolean execute(Object pred, int index) {
                GISModelWriter.this.PRED_LABELS[index] = (String)pred;
                return true;
            }
        });
    }

    protected abstract void writeUTF(String var1) throws IOException;

    protected abstract void writeInt(int var1) throws IOException;

    protected abstract void writeDouble(double var1) throws IOException;

    protected abstract void close() throws IOException;

    public void persist() throws IOException {
        this.writeUTF("GIS");
        this.writeInt(this.CORRECTION_CONSTANT);
        this.writeDouble(this.CORRECTION_PARAM);
        this.writeInt(this.OUTCOME_LABELS.length);
        int i = 0;
        while (i < this.OUTCOME_LABELS.length) {
            this.writeUTF(this.OUTCOME_LABELS[i]);
            ++i;
        }
        ComparablePredicate[] sorted = this.sortValues();
        List compressed = this.compressOutcomes(sorted);
        this.writeInt(compressed.size());
        int i2 = 0;
        while (i2 < compressed.size()) {
            List a = (List)compressed.get(i2);
            this.writeUTF(String.valueOf(a.size()) + ((ComparablePredicate)a.get(0)).toString());
            ++i2;
        }
        this.writeInt(this.PARAMS.length);
        i2 = 0;
        while (i2 < sorted.length) {
            this.writeUTF(sorted[i2].name);
            ++i2;
        }
        i2 = 0;
        while (i2 < sorted.length) {
            int j = 0;
            while (j < sorted[i2].params.length) {
                this.writeDouble(sorted[i2].params[j]);
                ++j;
            }
            ++i2;
        }
        this.close();
    }

    protected ComparablePredicate[] sortValues() {
        Object[] sortPreds = new ComparablePredicate[this.PARAMS.length];
        int numParams = 0;
        int pid = 0;
        while (pid < this.PARAMS.length) {
            int[] predkeys = this.PARAMS[pid].getOutcomes();
            int numActive = predkeys.length;
            int[] activeOutcomes = predkeys;
            double[] activeParams = this.PARAMS[pid].getParameters();
            numParams += numActive;
            sortPreds[pid] = new ComparablePredicate(this.PRED_LABELS[pid], activeOutcomes, activeParams);
            ++pid;
        }
        Arrays.sort(sortPreds);
        return sortPreds;
    }

    protected List compressOutcomes(ComparablePredicate[] sorted) {
        ComparablePredicate cp = sorted[0];
        ArrayList outcomePatterns = new ArrayList();
        ArrayList<ComparablePredicate> newGroup = new ArrayList<ComparablePredicate>();
        int i = 0;
        while (i < sorted.length) {
            if (cp.compareTo(sorted[i]) == 0) {
                newGroup.add(sorted[i]);
            } else {
                cp = sorted[i];
                outcomePatterns.add(newGroup);
                newGroup = new ArrayList();
                newGroup.add(sorted[i]);
            }
            ++i;
        }
        outcomePatterns.add(newGroup);
        return outcomePatterns;
    }
}

