/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.coref.resolver;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import opennlp.tools.coref.DiscourseEntity;
import opennlp.tools.coref.mention.MentionContext;
import opennlp.tools.coref.resolver.MaxentResolver;
import opennlp.tools.coref.resolver.NonReferentialResolver;
import opennlp.tools.coref.resolver.ResolverMode;

public class PluralNounResolver
extends MaxentResolver {
    public PluralNounResolver(String projectName, ResolverMode m) throws IOException {
        super(projectName, "plmodel", m, 80, true);
        this.showExclusions = false;
    }

    public PluralNounResolver(String projectName, ResolverMode m, NonReferentialResolver nrr) throws IOException {
        super(projectName, "plmodel", m, 80, true, nrr);
        this.showExclusions = false;
    }

    protected List getFeatures(MentionContext mention, DiscourseEntity entity) {
        ArrayList features = new ArrayList();
        features.addAll(super.getFeatures(mention, entity));
        if (entity != null) {
            features.addAll(PluralNounResolver.getContextFeatures(mention));
            features.addAll(this.getStringMatchFeatures(mention, entity));
        }
        return features;
    }

    public boolean canResolve(MentionContext mention) {
        String firstTok = mention.getFirstTokenText().toLowerCase();
        String firstTokTag = mention.getFirstToken().getSyntacticType();
        boolean rv = mention.getHeadTokenTag().equals("NNS") && !this.definiteArticle(firstTok, firstTokTag);
        return rv;
    }

    protected boolean excluded(MentionContext mention, DiscourseEntity entity) {
        if (super.excluded(mention, entity)) {
            return true;
        }
        MentionContext cec = entity.getLastExtent();
        return !cec.getHeadTokenTag().equals("NNS") || super.excluded(mention, entity);
    }
}

