/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.coref.sim;

import java.io.IOException;
import opennlp.tools.coref.sim.Context;
import opennlp.tools.coref.sim.Gender;
import opennlp.tools.coref.sim.GenderEnum;
import opennlp.tools.coref.sim.GenderModel;
import opennlp.tools.coref.sim.Number;
import opennlp.tools.coref.sim.NumberEnum;
import opennlp.tools.coref.sim.NumberModel;
import opennlp.tools.coref.sim.TestGenderModel;
import opennlp.tools.coref.sim.TestNumberModel;

public class MaxentCompatibilityModel {
    private final double minGenderProb = 0.66;
    private final double minNumberProb = 0.66;
    private static TestGenderModel genModel;
    private static TestNumberModel numModel;
    private boolean debugOn = false;

    public MaxentCompatibilityModel(String corefProject) throws IOException {
        genModel = GenderModel.testModel(corefProject + "/gen");
        numModel = NumberModel.testModel(corefProject + "/num");
    }

    public Gender computeGender(Context c) {
        double[] gdist = genModel.genderDistribution(c);
        if (this.debugOn) {
            System.err.println("MaxentCompatibilityModel.computeGender: " + c.toString() + " m=" + gdist[genModel.getMaleIndex()] + " f=" + gdist[genModel.getFemaleIndex()] + " n=" + gdist[genModel.getNeuterIndex()]);
        }
        Gender gender = genModel.getMaleIndex() >= 0 && gdist[genModel.getMaleIndex()] > 0.66 ? new Gender(GenderEnum.MALE, gdist[genModel.getMaleIndex()]) : (genModel.getFemaleIndex() >= 0 && gdist[genModel.getFemaleIndex()] > 0.66 ? new Gender(GenderEnum.FEMALE, gdist[genModel.getFemaleIndex()]) : (genModel.getNeuterIndex() >= 0 && gdist[genModel.getNeuterIndex()] > 0.66 ? new Gender(GenderEnum.NEUTER, gdist[genModel.getNeuterIndex()]) : new Gender(GenderEnum.UNKNOWN, 0.66)));
        return gender;
    }

    public Number computeNumber(Context c) {
        double[] dist = numModel.numberDist(c);
        Number number = dist[numModel.getSingularIndex()] > 0.66 ? new Number(NumberEnum.SINGULAR, dist[numModel.getSingularIndex()]) : (dist[numModel.getPluralIndex()] > 0.66 ? new Number(NumberEnum.PLURAL, dist[numModel.getPluralIndex()]) : new Number(NumberEnum.UNKNOWN, 0.66));
        return number;
    }
}

