% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/delete_lakes.R
\name{delete_lakes}
\alias{delete_lakes}
\title{Delete lakes from stream network}
\usage{
delete_lakes(lakes, keep = TRUE)
}
\arguments{
\item{lakes}{character string or object; path to lake vector file (ESRI shape), 
name of vector map in the GRASS data base or sp or sf data object.}

\item{keep}{boolean; should the original 'streams_v' be saved? Default is TRUE.}
}
\value{
Nothing. The function updates 'streams_v' and (if keep = TRUE) saves 
the original file to streams_v_prev_lakes. If \code{lakes} is a file path, the lakes
are imported into GRASS as 'lakes'.
}
\description{
When the stream network is derived from a dem, the streams 
will just cross lakes or ponds. However, the flow is disconnected
here and the relationship between sampling points upstream and
downstream of a lake is not clear. For instance, chemicals could
be retained and temperature altered in a lake. This function intersects
the stream network with a given vector map of lakes; it deletes the stream
segments in the lake, breaks those that cross its borders and 
assigns a new, updated topology.
}
\note{
The column 'out_dist' (flow length from the upstream node of the 
 segment to the outlet of the network) is updated based on the new segment length.
 In contrast, 'cum_length' is not updated as it is no longer needed and will 
 be deleted in calc_edges. 

#'
}
\examples{
\donttest{
dem_path <- system.file("extdata", "nc", "elev_ned_30m.tif", package = "openSTARS")
if(.Platform$OS.type == "windows"){
  grass_program_path = "c:/Program Files/GRASS GIS 7.6"
  } else {
  grass_program_path = "/usr/lib/grass78/"
  }

setup_grass_environment(dem = dem_path, 
                        gisBase = grass_program_path,      
                        remove_GISRC = TRUE,
                        override = TRUE
                        )
gmeta()
                        
# Load files into GRASS
dem_path <- system.file("extdata", "nc", "elev_ned_30m.tif", package = "openSTARS")
sites_path <- system.file("extdata", "nc", "sites_nc.shp", package = "openSTARS")
import_data(dem = dem_path, sites = sites_path)

# Derive streams from DEM
derive_streams(burn = 0, accum_threshold = 100, condition = TRUE, clean = TRUE)

# Check and correct complex confluences (there are no complex confluences in this
# example date set; set accum_threshold in derive_streams to a smaller value
# to create complex confluences)
cj <- check_compl_confluences()
if(cj){
  correct_compl_confluences()
}

lakes_path <- system.file("extdata", "nc", "lakes.shp", package = "openSTARS")
delete_lakes(lakes = lakes_path)

# plot
library(sp)
dem <- readRAST('dem', ignore.stderr = TRUE, plugin = FALSE)
streams <- readVECT('streams_v', ignore.stderr = TRUE)
streams_with_lakes <- readVECT('streams_v_prev_lakes', ignore.stderr = TRUE)
lakes <- readVECT('lakes', ignore.stderr = TRUE)

plot(dem, col = terrain.colors(20), axes = TRUE)
plot(lakes, add = TRUE, col = "grey")
lines(streams_with_lakes, col = 'red', lty = 1, lwd = 2)
lines(streams, col = 'blue', lty = 4, lwd = 2)
legend("topright", col = c("red", "blue"), lty = c(1,4), lwd = c(2,2), 
  legend = c("through lakes", "lakes cut out"))
}
}
\author{
Mira Kattwinkel  \email{mira.kattwinkel@gmx.net}
}
