% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CSMF.r
\name{getIndivProb}
\alias{getIndivProb}
\title{Extract individual distribution of cause of death}
\usage{
getIndivProb(x, CI = NULL, ...)
}
\arguments{
\item{x}{a fitted object from \code{codeVA}.}

\item{CI}{Credible interval for posterior estimates. If CI is set to TRUE, a list is returned instead of a data frame.}

\item{...}{additional arguments that can be passed to \code{get.indiv} from InSilicoVA package.}
}
\value{
a data frame of COD distribution for each individual specified by row names.
}
\description{
Extract individual distribution of cause of death
}
\examples{
data(RandomVA1)
# for illustration, only use interVA on 100 deaths
fit <- codeVA(RandomVA1[1:100, ], data.type = "WHO", model = "InterVA", 
                  version = "4.02", HIV = "h", Malaria = "l", write=FALSE)
probs <- getIndivProb(fit)

}
\seealso{
Other output extraction: 
\code{\link{getCCC}()},
\code{\link{getCSMF_accuracy}()},
\code{\link{getCSMF}()},
\code{\link{getTopCOD}()}
}
\concept{output extraction}
