% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oa_get.R
\name{oa_get}
\alias{oa_get}
\title{Get data from Openaddresses}
\usage{
oa_get(x, overwrite = FALSE, ...)
}
\arguments{
\item{x}{(character) URL for an openaddresses dataset, or an object of
class openadd}

\item{overwrite}{(logical) Will only overwrite existing path
if \code{TRUE}}

\item{...}{Pass on curl options to \code{\link[httr]{GET}}}
}
\value{
a tibble (a data.frame), with attributes for original url and path on disk
}
\description{
Get data from Openaddresses
}
\examples{
\dontrun{
dat <- oa_list()
urls <- na.omit(dat$processed)
(out1 <- oa_get(urls[6]))
(out3 <- oa_get(urls[32]))
(out4 <- oa_get(urls[876]))
(out5 <- oa_get(urls[376]))
(out6 <- oa_get(urls[474]))
(out7 <- oa_get(urls[121]))
(out8 <- oa_get(urls[41]))
(out9 <- oa_get(urls[400]))

# from a openadd class object
oa_get(as_openadd(country="us", state="nv", city="las_vegas"))

# combine data sets
(alldat <- oa_combine(out1, out3))

# Map data
if (!requireNamespace("leaflet")) {
  install.packages("leaflet")
}
library("leaflet")
small <- out9[1:10000L, ]
leaflet(small) \%>\%
  addTiles() \%>\%
  addCircles(lat = ~LAT, lng = ~LON,
             popup = unname(apply(small[, c('NUMBER', 'STREET')], 1, paste, collapse = " ")))
}
}
\references{
\url{http://openaddresses.io/}
}

