% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/list_fine_tune_events.R
\name{list_fine_tune_events}
\alias{list_fine_tune_events}
\title{List fine-tune events}
\usage{
list_fine_tune_events(
  fine_tune_id,
  stream = FALSE,
  openai_api_key = Sys.getenv("OPENAI_API_KEY"),
  openai_organization = NULL
)
}
\arguments{
\item{fine_tune_id}{required; a length one character vector.}

\item{stream}{required; defaults to \code{FALSE}; a length one logical vector.
\strong{Currently is not implemented.}}

\item{openai_api_key}{required; defaults to \code{Sys.getenv("OPENAI_API_KEY")}
(i.e., the value is retrieved from the \code{.Renviron} file); a length one
character vector. Specifies OpenAI API key.}

\item{openai_organization}{optional; defaults to \code{NULL}; a length one
character vector. Specifies OpenAI organization.}
}
\value{
Returns a list, elements of which contains information about the
fine-tune events.
}
\description{
Returns events related to a specidied fine-tune job. See \href{https://beta.openai.com/docs/api-reference/fine-tunes/events}{this page} for
details.
}
\details{
For arguments description please refer to the \href{https://beta.openai.com/docs/api-reference/fine-tunes/events}{official documentation}.
}
\examples{
\dontrun{
training_file <- system.file(
    "extdata", "sport_prepared_train.jsonl", package = "openai"
)
validation_file <- system.file(
    "extdata", "sport_prepared_train.jsonl", package = "openai"
)

training_info <- upload_file(training_file, "fine-tune")
validation_info <- upload_file(validation_file, "fine-tune")

info <- create_fine_tune(
    training_file = training_info$id,
    validation_file = validation_info$id,
    model = "ada",
    compute_classification_metrics = TRUE,
    classification_positive_class = " baseball" # Mind space in front
)

id <- ifelse(
    length(info$data$id) > 1,
    info$data$id[length(info$data$id)],
    info$data$id
)

list_fine_tune_events(fine_tune_id = id)
}
}
\seealso{
Other fine-tune functions: 
\code{\link{cancel_fine_tune}()},
\code{\link{create_fine_tune}()},
\code{\link{delete_fine_tune_model}()},
\code{\link{list_fine_tunes}()},
\code{\link{retrieve_fine_tune}()}
}
\concept{fine-tune functions}
