% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/polarMap.R
\name{polarMap}
\alias{polarMap}
\title{Bivariate polar plots on interactive leaflet maps}
\usage{
polarMap(
  data,
  pollutant = NULL,
  x = "ws",
  latitude = NULL,
  longitude = NULL,
  control = NULL,
  popup = NULL,
  label = NULL,
  provider = "OpenStreetMap",
  cols = "jet",
  alpha = 1,
  key = FALSE,
  iconWidth = 200,
  iconHeight = 200,
  fig.width = 4,
  fig.height = 4,
  type = NULL,
  ...
)
}
\arguments{
\item{data}{A data frame. The data frame must contain the data to plot a
\code{\link[openair:polarPlot]{openair::polarPlot()}}, which includes wind speed (\code{ws}), wind
direction (\code{wd}), and the column representing the concentration of a
pollutant. In addition, \code{data} must include a decimal latitude and
longitude.}

\item{pollutant}{The column name(s) of the pollutant(s) to plot. If multiple
pollutants are specified, they can be toggled between using a "layer
control" interface.}

\item{x}{The radial axis variable to plot.}

\item{latitude}{The decimal latitude. If not provided, latitude will be
automatically inferred from data by looking for a column named \dQuote{lat}
or \dQuote{latitude} (case-insensitively).}

\item{longitude}{The decimal longitude. If not provided, longitude will be
automatically inferred from data by looking for a column named
\dQuote{lon}, \dQuote{lng}, \dQuote{long}, or \dQuote{longitude}
(case-insensitively).}

\item{control}{Column to be used for splitting the input data into different
groups which can be selected between using a "layer control" interface.
Appropriate columns could be those added by \code{\link[openair:cutData]{openair::cutData()}} or
\code{\link[openair:splitByDate]{openair::splitByDate()}}. \code{control} cannot be used if multiple
\code{pollutant} columns have been provided.}

\item{popup}{Column to be used as the HTML content for marker popups. Popups
may be useful to show information about the individual sites (e.g., site
names, codes, types, etc.).}

\item{label}{Column to be used as the HTML content for hover-over labels.
Labels are useful for the same reasons as popups, though are typically
shorter.}

\item{provider}{The base map(s) to be used. See
\url{http://leaflet-extras.github.io/leaflet-providers/preview/} for a list
of all base maps that can be used. If multiple base maps are provided, they
can be toggled between using a "layer control" interface.}

\item{cols}{The colours used for plotting.}

\item{alpha}{The alpha transparency to use for the plotting surface (a value
between 0 and 1 with zero being fully transparent and 1 fully opaque).}

\item{key}{Should the key of the plot be drawn. Default is \code{FALSE}.}

\item{iconWidth}{The actual width of the plot on the map in pixels.}

\item{iconHeight}{The actual height of the plot on the map in pixels.}

\item{fig.width}{The width of the plots to be produced in inches.}

\item{fig.height}{The height of the plots to be produced in inches.}

\item{type}{Deprecated. Please use \code{label} and/or \code{popup} to label
different sites.}

\item{...}{Other arguments for \code{\link[openair:polarPlot]{openair::polarPlot()}}.}
}
\value{
A leaflet object.
}
\description{
\code{\link[=polarMap]{polarMap()}} creates a \code{leaflet} map using bivariate polar plots as
markers. Any number of pollutants can be specified using the \code{pollutant}
argument, and multiple layers of markers can be added and toggled between
using \code{control}. See \code{\link[openair:polarPlot]{openair::polarPlot()}} for more information.
}
\examples{
\dontrun{
polarMap(polar_data,
  pollutant = "nox",
  x = "ws",
  provider = "Stamen.Toner"
)
}
}
\seealso{
Directional analysis maps: \code{\link[=annulusMap]{annulusMap()}}, \code{\link[=freqMap]{freqMap()}},
\code{\link[=percentileMap]{percentileMap()}}, \code{\link[=polarMap]{polarMap()}}, \code{\link[=pollroseMap]{pollroseMap()}}, \code{\link[=windroseMap]{windroseMap()}}.
}
