% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oc_event.R
\name{oc_event}
\alias{oc_event}
\title{Query Opencast for a specific event}
\usage{
oc_event(eventId = "", sign = FALSE, withacl = FALSE,
  withmetadata = FALSE, withscheduling = FALSE,
  withpublications = FALSE)
}
\arguments{
\item{eventId}{The event id}

\item{sign}{Whether public distribution urls should be signed.}

\item{withacl}{Whether the acl metadata should be included in the response.}

\item{withmetadata}{Whether the metadata catalogs should be included in the response.}

\item{withscheduling}{Whether the scheduling information should be included in the response.}

\item{withpublications}{Whether the publication ids and urls should be included in the response.}
}
\value{
Returns a single event.
}
\description{
Returns a single event.
}
\details{
This function expects the hostname, username and password to be set as environment variables.
}
\examples{
Sys.setenv(OPENCAST_HOST = "https://legacy.opencast.org")
Sys.setenv(OPENCAST_USERNAME = "admin")
Sys.setenv(OPENCAST_PASSWORD = "opencast")

events <- oc_list_events()

oc_event(events$content$identifier[1])
}
