parse_query <- function(query){
  if(is.raw(query)){
    query <- rawToChar(query);
  }
  stopifnot(is.character(query));

  #httpuv includes the question mark in query string
  if(identical(substring(query, 1,1), "?")){
    query <- substring(query, 2);
  }
  
  argslist <- strsplit(query, "&")[[1]];
  argslist <- strsplit(argslist, "=");
  ARGS <- lapply(argslist, "[[", 2);
  ARGS <- lapply(ARGS, function(s) {utils::URLdecode(chartr('+',' ',s))});
  names(ARGS) <- lapply(argslist, "[[", 1);    
  return(ARGS)
}