% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/argument_types.R
\name{Argument}
\alias{Argument}
\title{Argument class}
\value{
Object of \code{\link{R6Class}} representing an argument.
}
\description{
This class inherits all fields and functions from \code{\link{Parameter}} adds the functionality to
manage a value. This includes getter/setter, validation and serialization. Since this is the parent class
for the type specific argument classes, the inheriting classes implement their own version of the private
functions \code{$typeCheck()} and \code{$typeSerialization()}.
}
\section{Methods}{

\describe{
  \item{\code{$setValue(value)}}{Assigns a value to this argument}
  \item{\code{$getValue()}}{Returns the value of this argument}
  \item{\code{$serialize()}}{returns a list representation of a openEO argument}
  \item{\code{$validate()}}{return TRUE if the parameter is validated positively by the type check}
  \item{\code{$isEmpty()}}{returns TRUE if the value is set}
  \item{\code{$getProcess()}}{returns the process this parameter belongs to}
  \item{\code{$setProcess(p)}}{sets the owning process for this parameter}
}
}

\section{Arguments}{
 
\describe{
  \item{\code{value}}{The value for this argument.}
  \item{\code{p}}{An object of class 'Process' or inheriting like 'ProcessNode'}
}
}

