% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pkcs12.R
\name{write_pkcs12}
\alias{write_pkcs12}
\alias{pkcs12}
\alias{read_pkcs12}
\title{PKCS12 bundles}
\usage{
write_pkcs12(key = NULL, cert = NULL, ca = NULL, name = NULL,
  password = NULL, path = NULL)

read_pkcs12(file, password = askpass)
}
\arguments{
\item{key}{a private key}

\item{cert}{certificate that matches `key`}

\item{ca}{a list of certificates stores in as the ca chain}

\item{name}{a friendly title for the bundle}

\item{password}{string or function to set/get the password.}

\item{path}{a file where to write the output to. If `NULL` the output is returned
as a raw vector.}

\item{file}{path or raw vector with binary PKCS12 data to parse}
}
\description{
PKCS12 is a format for bundling a private key, a certificate and a certificate chain
in a single password-protected file. At least one of `key`, `cert` or `ca` must
be non-NULL.
}

