% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cert.R
\name{cert_verify}
\alias{cert_verify}
\alias{download_ssl_cert}
\alias{ca_bundle}
\title{X509 certificates}
\usage{
cert_verify(cert, root = ca_bundle())

download_ssl_cert(host = "localhost", port = 443, ipv4_only = FALSE)

ca_bundle()
}
\arguments{
\item{cert}{certificate (or certificate-chain) to be verified. Must be cert or list or path.}

\item{root}{trusted pubkey or certificate(s) e.g. CA bundle.}

\item{host}{string: hostname of the server to connect to}

\item{port}{string or integer: port or protocol to use, e.g: \code{443} or \code{"https"}}

\item{ipv4_only}{do not use IPv6 connections}
}
\description{
Read, download, analyze and verify X.509 certificates.
}
\examples{
# Verify the r-project HTTPS cert
chain <- download_ssl_cert("cran.r-project.org", 443)
print(chain)
cert_data <- as.list(chain[[1]])
print(cert_data$pubkey)
print(cert_data$alt_names)
cert_verify(chain, ca_bundle())

# Write cert in PEM format
cat(write_pem(chain[[1]]))
}
\seealso{
\link{read_cert}
}
