% Generated by roxygen2 (4.0.1): do not edit by hand
\name{setHeaderFooter}
\alias{setHeaderFooter}
\title{Set document headers and footers}
\usage{
setHeaderFooter(wb, sheet, header = NULL, footer = NULL,
  evenHeader = NULL, evenFooter = NULL, firstHeader = NULL,
  firstFooter = NULL)
}
\arguments{
\item{wb}{A workbook object}

\item{sheet}{A name or index of a worksheet}

\item{header}{document header. Character vector of length 3 corresponding to positons left, center, right. Use NA to skip a positon.}

\item{footer}{document footer. Character vector of length 3 corresponding to positons left, center, right. Use NA to skip a positon.}

\item{evenHeader}{document header for even pages.}

\item{evenFooter}{document footer for even pages.}

\item{firstHeader}{document header for first page only.}

\item{firstFooter}{document footer for first page only.}
}
\description{
Set document headers and footers
}
\details{
Headers and footers can contain special tags
\itemize{
  \item{\bold{&[Page]}}{ Page number}
  \item{\bold{&[Pages]}}{ Number of pages}
  \item{\bold{&[Date]}}{ Current date}
  \item{\bold{&[Time]}}{ Current time}
  \item{\bold{&[Path]}}{ File path}
  \item{\bold{&[File]}}{ File name}
  \item{\bold{&[Tab]}}{ Worksheet name}
}
}
\examples{
wb <- createWorkbook()

addWorksheet(wb, "S1")
addWorksheet(wb, "S2")
addWorksheet(wb, "S3")
addWorksheet(wb, "S4")

writeData(wb, 1, 1:400)
writeData(wb, 2, 1:400)
writeData(wb, 3, 3:400)
writeData(wb, 4, 3:400)

setHeaderFooter(wb, sheet = "S1",
                header = c("ODD HEAD LEFT", "ODD HEAD CENTER", "ODD HEAD RIGHT"),
                footer = c("ODD FOOT RIGHT", "ODD FOOT CENTER", "ODD FOOT RIGHT"),
                evenHeader = c("EVEN HEAD LEFT", "EVEN HEAD CENTER", "EVEN HEAD RIGHT"),
                evenFooter = c("EVEN FOOT RIGHT", "EVEN FOOT CENTER", "EVEN FOOT RIGHT"),
                firstHeader = c("TOP", "OF FIRST", "PAGE"),
                firstFooter = c("BOTTOM", "OF FIRST", "PAGE"))

setHeaderFooter(wb, sheet = 2,
                header = c("&[Date]", "ALL HEAD CENTER 2", "&[Page] / &[Pages]"),
                footer = c("&[Path]&[File]", NA, "&[Tab]"),
                firstHeader = c(NA, "Center Header of First Page", NA),
                firstFooter = c(NA, "Center Footer of First Page", NA))

setHeaderFooter(wb, sheet = 3,
                header = c("ALL HEAD LEFT 2", "ALL HEAD CENTER 2", "ALL HEAD RIGHT 2"),
                footer = c("ALL FOOT RIGHT 2", "ALL FOOT CENTER 2", "ALL FOOT RIGHT 2"))

setHeaderFooter(wb, sheet = 4,
                firstHeader = c("FIRST ONLY L", NA, "FIRST ONLY R"),
                firstFooter = c("FIRST ONLY L", NA, "FIRST ONLY R"))


saveWorkbook(wb, "setHeaderFooterExample.xlsx", overwrite = TRUE)
}
\author{
Alexander Walker
}
\seealso{
\code{\link{addWorksheet}} to set headers and footers when adding a worksheet
}

