% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{dims_helper}
\alias{dims_helper}
\alias{dims_to_rowcol}
\alias{rowcol_to_dims}
\title{Helper functions to work with \code{dims}}
\usage{
dims_to_rowcol(x, as_integer = FALSE)

rowcol_to_dims(row, col, single = TRUE, fix = NULL)
}
\arguments{
\item{x}{a dimension object "A1" or "A1:A1"}

\item{as_integer}{If the output should be returned as integer, (defaults to string)}

\item{row}{a numeric vector of rows}

\item{col}{a numeric or character vector of cols}

\item{single}{argument indicating if \code{\link[=rowcol_to_dims]{rowcol_to_dims()}} returns a single cell dimension}

\item{fix}{setting the type of the reference. Per default, no type is set. Options are
\code{"all"}, \code{"row"}, and \code{"col"}}
}
\value{
\itemize{
\item A \code{dims} string for \verb{_to_dim} i.e  "A1:A1"
\item A named list of rows and columns for \code{to_rowcol}
}
}
\description{
Internal helpers to (de)construct a dims argument from/to a row and column
vector. Exported for user convenience.
}
\examples{
dims_to_rowcol("A1:J10")
wb_dims(1:10, 1:10)

}
\seealso{
\code{\link[=wb_dims]{wb_dims()}}
}
