% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_lpsolveapi_solver.R
\name{add_lpsolveapi_solver}
\alias{add_lpsolveapi_solver}
\title{Add a lp_solve solver with \pkg{lpSolveAPI}}
\usage{
add_lpsolveapi_solver(x, gap = 0, presolve = FALSE, verbose = TRUE)
}
\arguments{
\item{x}{\code{\link{ProjectProblem-class}} object.}

\item{gap}{\code{numeric} gap to optimality. This gap is relative when
solving problems using \pkg{gurobi}, and will cause the optimizer to
terminate when the difference between the upper and lower objective
function bounds is less than the gap times the upper bound. For example, a
value of 0.01 will result in the optimizer stopping when the difference
between the bounds is 1 percent of the upper bound. For
other solvers, this is the absolute gap, so if the optimal value for
a maximization problem is 10, a gap of 0.01 means that a solution between
10 and 10.01 is required. Defaults to 0, so that optimal solutions will be
returned.}

\item{presolve}{\code{logical} indicating if attempts to should be made
to simplify the optimization problem (\code{TRUE}) or not (\code{FALSE}).
Defaults to \code{TRUE}.}

\item{verbose}{\code{logical} should information be printed while solving
optimization problems?}
}
\value{
\code{\link{ProjectProblem-class}} object with the solver added
  to it.
}
\description{
Specify that the \emph{lp_solve} software should be used to solve a
project prioritization \code{\link{problem}} using the \pkg{lpSolveAPI}
package. This function can also be used to customize the behavior of the
solver. It requires the \pkg{lpSolveAPI} package.
}
\details{
\href{http://lpsolve.sourceforge.net/5.5/}{\emph{lp_solve}} is an
  open-source integer programming solver.
  Although this solver is the slowest currently supported solver,
  it is also the only exact algorithm solver that can be installed on all
  operating systems without any manual installation steps. This solver is
  provided so that
  users can try solving small project prioritization problems, without
  needing to install additional software. When solve moderate or large
  project prioritization problems, consider using
  \code{\link{add_gurobi_solver}}.
}
\examples{
# load data
data(sim_projects, sim_features, sim_actions)

# build problem with lpSolveAPI solver
p <- problem(sim_projects, sim_actions, sim_features,
             "name", "success", "name", "cost", "name") \%>\%
     add_max_richness_objective(budget = 200) \%>\%
     add_binary_decisions() \%>\%
     add_lpsolveapi_solver()

# print problem
print(p)

# solve problem
s <- solve(p)

# print solution
print(s)

# plot solution
plot(p, s)
}
\seealso{
\code{\link{solvers}}.
}
