% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_feature_persistence.R
\name{plot_feature_persistence}
\alias{plot_feature_persistence}
\title{Plot a bar plot to visualize a project prioritization}
\usage{
plot_feature_persistence(x, solution, n = 1, symbol_hjust = 0.007,
  return_data = FALSE)
}
\arguments{
\item{x}{project prioritization \code{\link{problem}}.}

\item{solution}{\code{\link[base]{data.frame}} or
\code{\link[tibble]{tibble}} table containing the solutions. Here,
rows correspond to different solutions and columns correspond to
different actions. Each column in the argument to \code{solution} should
be named according to a different action in \code{x}.
Cell values indicate if an action is funded in a given solution or not,
and should be either zero or one. Arguments to \code{solution} can
contain additional columns, and they will be ignored.}

\item{n}{\code{integer} solution number to visualize.
Since each row in the argument to \code{solutions} corresponds to a
different solution, this argument should correspond to a row in
the argument to \code{solutions}. Defaults to 1.}

\item{symbol_hjust}{\code{numeric} horizontal adjustment parameter to
manually align the asterisks and dashes in the plot. Defaults to
\code{0.007}. Increasing this parameter will shift the symbols further
right. Please note that this parameter may require some tweaking
to produce visually appealing publication quality plots.}

\item{return_data}{\code{logical} should the underlying data used to create
the plot be returned instead of the plot? Defaults to \code{FALSE}.}
}
\value{
A \code{\link{ggplot}} object, or a
  \code{\link[tibble]{tbl_df}} object if \code{return_data} is
  \code{TRUE}.
}
\description{
Create a bar plot to visualize how likely features are to persist into
the future under a solution to a project prioritization problem.
}
\details{
In this plot, each bar corresponds to a different feature.
  The length of each bar indicates the probability that a given feature
  will persist into the future, and the color of each bar indicates
  the weight for a given feature.
  Features that directly benefit from at least a single completely funded
  project with a non-zero cost are depicted with an asterisk symbol.
  Additionally, features that indirectly benefit from funded
  projects---because they are associated with partially funded
  projects that have non-zero costs and share actions with at least one
  completely funded project---are depicted with an open circle symbol.
}
\examples{
# set seed for reproducibility
set.seed(500)

# load the ggplot2 R package to customize plots
library(ggplot2)

# load data
data(sim_projects, sim_features, sim_actions)

# build problem
p <- problem(sim_projects, sim_actions, sim_features,
             "name", "success", "name", "cost", "name") \%>\%
      add_max_richness_objective(budget = 400) \%>\%
      add_feature_weights("weight") \%>\%
      add_binary_decisions() \%>\%
      add_heuristic_solver(n = 10)

\donttest{
# solve problem
s <- solve(p)

# plot the first solution
plot(p, s)

# plot the second solution
plot(p, s, n = 2)

# since this function returns a ggplot2 plot object, we can customize the
# appearance of the plot using standard ggplot2 commands!
# for example, we can add a title
plot(p, s) + ggtitle("solution")

# we can also obtain the raw plotting data using return_data=TRUE
plot_data <- plot(p, s, return_data = TRUE)
print(plot_data)
}
}
