% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/legacy.R
\name{new_optimizer}
\alias{new_optimizer}
\title{Construct \code{optimizer} object}
\usage{
new_optimizer(
  x = list(),
  .optimizer = function() {
 },
  optimizer_name = character(),
  optimizer_arguments = list(),
  .objective = character(),
  .initial = character(),
  .value = character(),
  .parameter = character(),
  .direction = character(),
  .output_ignore = character()
)
}
\arguments{
\item{x}{A \code{list}.}

\item{.optimizer}{A \code{function}, a numerical optimizer. Four conditions must be met:
\enumerate{
\item It must have an input named \code{.objective} for a \code{function}, the
objective function which is optimized over its first argument.
\item It must have an input named \code{.initial} for a \code{numerical}
vector, the initial parameter vector.
\item It must have a \code{...} argument for additional parameters to
the objective function.
\item The output must be a named \code{list}, including the optimal function
value and the optimal parameter vector.
}}

\item{optimizer_name}{A \code{character}, the name of \code{optimizer}.}

\item{optimizer_arguments}{A \code{list} of additional and named arguments to be passed to
\code{optimizer}.}

\item{.objective}{A \code{character}, the name of the function input of \code{optimizer}.}

\item{.initial}{A \code{character}, the name of the starting parameter values input of
\code{optimizer}.}

\item{.value}{A \code{character}, the name of the optimal function value in the output list
of \code{optimizer}.}

\item{.parameter}{A \code{character}, the name of the optimal parameter vector in the output
list of \code{optimizer}.}

\item{.direction}{A \code{character}, indicates whether the optimizer minimizes (\code{"min"})
or maximizes (\code{"max"}).}

\item{.output_ignore}{A \code{character} vector of element names in the output of \code{.optimizer}
that are not saved. The elements \code{.value} and \code{.parameter} are
added automatically to \code{.output_ignore}, because they are saved
separately, see the output documentation of \code{\link{apply_optimizer}}.}
}
\value{
An S3 object of class \code{optimizer}.
}
\description{
This function constructs an S3 \code{optimizer} object.
}
\section{Format}{
An \code{optimizer} object is a \code{list} of six elements:
\describe{
\item{optimizer}{A \code{function}, the optimization algorithm.}
\item{optimizer_name}{A \code{character}, the name of
\code{optimizer}.}
\item{optimizer_arguments}{A named \code{list}, where each element
is an additional function argument for \code{optimizer}.}
\item{optimizer_direction}{Either \code{"min"} if the optimizer minimizes
or \code{"max"} if the optimizer maximizes.}
\item{optimizer_labels}{A named \code{list} of four
\code{character}:
\describe{
\item{objective}{the name of the function input of \code{optimizer}}
\item{initial}{the name of the starting parameter values input of
\code{optimizer}}
\item{value}{the name of the optimal function value in the output list
of \code{optimizer}}
\item{parameter}{the name of the optimal parameter vector in the
output list of \code{optimizer}.}
}}
\item{output_ignore}{A \code{character} vector of element
names in the output \code{list} of \code{optimizer} that are ignored.
The elements \code{value} and \code{parameter} are added automatically to
\code{output_ignore}, because they are saved
separately, see the output documentation of \code{\link{apply_optimizer}}.}
}
}

\keyword{internal}
