% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optional.R
\name{fallthrough}
\alias{fallthrough}
\title{Fallthrough function}
\usage{
fallthrough(fun)
}
\arguments{
\item{fun}{A result function used in \code{make_opt()}}
}
\description{
Permit a pattern matching to continue even if its argument is executed.
}
\details{
\code{fallthrough(fun)} can be applied to a result function \code{fun} inside a 
\code{match_with()} pattern.
If there is a match, this will make the pattern matching
continue through the other conditions at the end of the result function \code{fun}.
\code{match_with(variable,
pattern, fallthrough(result-function),
...}
}
\examples{
library(magrittr)

a <- 4
match_with(a,
  . \%>\% if (. \%\% 2 == 0)., 
  fallthrough( function() "This number is even" ),
  . \%>\% if ( sqrt(.) == round(sqrt(.)) ).,  
  function() "This number is a perfect square"
)
## [1] "This number is even"   "This number is a perfect square"
}
