% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/options_roxygen.R
\name{as_params}
\alias{as_params}
\title{Produce \verb{@param} roxygen sections for options}
\usage{
as_params(...)
}
\arguments{
\item{...}{Character values of options to use. If named arguments are
provided, the option description provided as the value is mapped to a
parameter of the argument's name.}
}
\value{
A character vector of \code{roxygen2} \verb{@param} tags
}
\description{
Generate parameter documentation based on option behaviors. Especially useful
for ubiquitous function parameters that default to option values.
}
\examples{
options::define_options(
  "whether messages should be written softly, or in all-caps",
  quiet = TRUE
)

#' Hello, World
#'
#' @eval options::as_params("softly" = "quiet")
#'
hello <- function(who, softly = opt("quiet")) {
  say_what <- paste0("Hello, ", who, "!")
  if (quiet) say_what else toupper(say_what)
}

}
\seealso{
Other options_roxygen2: 
\code{\link{as_roxygen_docs}()}
}
\concept{options_roxygen2}
\keyword{roxygen2}
