% Generated by roxygen2 (4.0.2): do not edit by hand
\name{timeLagLasso.path}
\alias{timeLagLasso.path}
\title{Fit a path of time-lasso models}
\usage{
timeLagLasso.path(x, y, lamlist = NULL, minlam = NULL, maxlam = NULL,
  nlam = 10, flmin = 0.01, strongly.ordered = TRUE, flmax = 1, maxlag,
  intercept = TRUE, standardize = TRUE, method = c("Solve.QP", "GG"),
  maxiter = 500, inneriter = 100, iter.gg = 100, trace = FALSE,
  epsilon = 1e-05)
}
\arguments{
\item{x}{A matrix of predictors, where the rows are the samples and the columns are the predictors}

\item{y}{A vector of observations, where length(y)  equals nrow(x)}

\item{lamlist}{Optional vector of values of lambda (the regularization parameter)}

\item{minlam}{Optional minimum value for lambda}

\item{maxlam}{Optional maximum value for lambda}

\item{nlam}{Number of values of lambda to be tried}

\item{flmin}{Fraction of maxlam minlam= flmin*maxlam. If computation is slow, try increasing
flmin to focus on the sparser part of the path; default = 1e-2.}

\item{strongly.ordered}{An option which allows users to order the coefficients in absolute value.}

\item{flmax}{Multiplication of maxlam maxlam = flmax * maxlam. Default = 1}

\item{maxlag}{Maximum time-lag chosen by user.}

\item{intercept}{True if there is an intercept in the model.}

\item{standardize}{Standardize the data matrix x.}

\item{method}{Two options available, Solve.QP and Generalized Gradient}

\item{maxiter}{Maximum  iterations run by time-lag lasso. Initiazlied to 500.}

\item{inneriter}{maximum iterations run by orderedLasso. Initialized to 100.}

\item{iter.gg}{Maximum iterations run by generalized gradient. Intialized to 100}

\item{trace}{Output option; trace = TRUE gives verbose output.}

\item{epsilon}{Error tolerance parameter for convergence criterion; default 1e-5}
}
\value{
\item{bp}{p by nlam  matrix of estimated positive coefficients(p=#variables)}
\item{bn}{p by nlam  matrix of estimated negative coefficients}
\item{beta}{p by nlam  matrix of estimated coefficients}
\item{b0}{a vector of length nlam of estimated intercept}
\item{lamlist}{Vector of values of lambda used}
\item{err}{Vector of errors}
\item{maxlag}{Maximum time-lag variable}
\item{p}{The number of predictors}
\item{fited}{a length(y) by nlam matrix of fitted values}
\item{call}{The call to "timeLagLasso.path"}
}
\description{
Fit a path of time-lasso models
}
\examples{
set.seed(3)
n = 50
maxlag = 5
num_rows_needed = n + maxlag + 1
sigma = 4
x = matrix(rnorm(num_rows_needed * 4), nrow = num_rows_needed)
x_new = time_lag_matrix(x, maxlag)
b = c(3,1,1,0,0,
      4,1,0,0,0,
      3,2,1,0,0,
      1,0,0,0,0)
y = x_new \%*\% b + sigma* rnorm(nrow(x_new))
y = as.vector(y)
y = c(y, rnorm(maxlag + 1))
path1 = timeLagLasso.path(x= x, y = y, maxlag = 5, method = "Solve.QP", strongly.ordered = TRUE)
plot(path1)
}

