% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/new.R
\name{orderly_new}
\alias{orderly_new}
\title{Create new report}
\usage{
orderly_new(name, root = NULL, locate = TRUE, quiet = FALSE, template = NULL)
}
\arguments{
\item{name}{Name of the new report (will be a directory name).}

\item{root}{The path to an orderly root directory, or \code{NULL}
(the default) to search for one from the current working
directory if \code{locate} is \code{TRUE}.}

\item{locate}{Logical, indicating if the configuration should be
searched for.  If \code{TRUE} and \code{config} is not given,
then orderly looks in the working directory and up through its
parents until it finds an \code{orderly_config.yml} file.}

\item{quiet}{Logical, indicating if informational messages should
be suppressed.}

\item{template}{The name of a template.  If \code{NULL} orderly
will search for a template (see Details).  If given it must be
the name of a directory within a directory \code{templates} in
your project root.  The special label "orderly" will use
orderly's builtin template.}
}
\value{
The path of the new source directory, invisibly
}
\description{
Create new report, starting from a template.  Orderly comes with a
set of templates, but projects can bring their own templates; see
Details below for how these are configured and discovered by
orderly.
}
\details{
To create a custom template, create a directory \code{templates}
within your orderly root.  Within that directory create
directories containing all the files that you would like a report
to contain.  This \emph{must} contain a file
\code{orderly.yml} but may contain further files (for example, you
might want a default script and Rmd file).

If \code{template} is not given (i.e., is \code{NULL}) then we
look for a template called \code{default} (i.e., stored at
\code{template/default}), then fall back on the system orderly
template.

We first look for a file \code{orderly/template.yml} within the
orderly root.  If that is not found, then a copy from the orderly
package is used.  This can always be used by using \code{template = "system"}.
}
\examples{
path <- orderly::orderly_example("minimal")

# Create a new report with the name "myreport" in this orderly
# repository:
orderly::orderly_new("myreport", root = path)

# The directory will be initialised with a orderly.yml file
# containing documentation
dir(file.path(path, "src", "myreport"))
readLines(file.path(path, "src", "myreport", "orderly.yml"))
}
\seealso{
\code{\link[=orderly_init]{orderly_init()}} for initialising a new orderly
repository.
}
