% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/gfunction.R
\name{g_glf_inv}
\alias{g_glf_inv}
\title{Inverse of generalized logistic g function}
\usage{
g_glf_inv(W, par)
}
\arguments{
\item{W}{vector of scores on the latent scale \eqn{(-\infty,\infty)}}

\item{par}{vector of 3 elements: \code{M}, the offset of the curve, \code{B}, the slope of the curve, and \code{T}, the symmetry
of the curve}
}
\value{
A vector of length equal to the length of \code{W}, with values \eqn{g^{-1}(W)}
}
\description{
Inverse of a parametric version of the g function
following Richards (1959):
\deqn{g^{-1}(W) = \left( \frac{e^{B(W-M)}}{T+e^{B(W-M)}}  \right)^{\frac{1}{T}}}
}
\author{
Maurizio Manuguerra, Gillian Heller
}
\references{
Richards, F. (1959). A flexible growth function for empirical use,
\emph{Journal of Experimental Botany}, 10, 290-301.
}
\seealso{
\code{\link{g_glf}},\code{\link{dg_glf}}
}
\keyword{Richards,}
\keyword{function.}
\keyword{generalized}
\keyword{logistic}

