% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/ocmm.R
\name{negloglik_glf_rnd}
\alias{negloglik_glf_rnd}
\title{Log-likelihood function for the mixed-effects model}
\usage{
negloglik_glf_rnd(par, v, d.matrix, rnd.matrix, wts, len_beta, rnd, n_nodes,
  quad, iclusters)
}
\arguments{
\item{par}{vector of regression coefficients,
\code{M},  \code{B}, \code{T}, (offset, slope and symmetry of the g function)
and the standard deviation of the random effect}

\item{v}{vector of standardized scores from the continuous ordinal scale}

\item{d.matrix}{design matrix (fixed effects)}

\item{rnd.matrix}{random term model matrix}

\item{wts}{optional case weights}

\item{len_beta}{length of the regression coefficients vector}

\item{rnd}{character vector listing the random terms}

\item{n_nodes}{order of Gauss-Hermite rule used (number of nodes)}

\item{quad}{string indicating the type of quadrature used to integrate over the random
effects. Can take values \code{"Laplace"} (Adaptive Gauss-Hermite quadrature using Laplace
approximation; the default) or \code{"GH"} (Gauss-Hermite quadrature).}

\item{iclusters}{list containing the row numbers of the design matrix relative to each level
of the factor over which random effects are computed}
}
\value{
Minus the log-likelihood at parameter values \code{par}
}
\description{
Log-likelihood function for the mixed-effects continuous ordinal model, using the generalized logistic
function as g function and the logit link function
}
\details{
This function computes minus the log-likelihood function for a mixed-effects model using the
generalized logistic function as g function and the logit link function. It is used internally to fit the model and should not be of interest of the user.
}
\author{
Maurizio Manuguerra, Gillian Heller
}
\keyword{likelihood,}
\keyword{log-likelihood.}

