% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/ocmm.methods.R
\name{print.anova.ocmm}
\alias{print.anova.ocmm}
\title{Print anova.ocmm objects}
\usage{
\method{print}{anova.ocmm}(x, digits = max(getOption("digits") - 2, 3),
  signif.stars = getOption("show.signif.stars"), ...)
}
\arguments{
\item{x}{an object of class \code{anova.ocmm}}

\item{digits}{controls the number of digits to print. Defaults to the maximum of the value returned by (getOption("digits") - 2) and 3}

\item{signif.stars}{a logical. Should the significance stars be printed? Defaults to the value returned by getOption("show.signif.stars")}

\item{...}{further arguments passed to or from other methods}
}
\value{
Prints \code{anova.ocmm} object
}
\description{
Print the results of the comparison of continuous ordinal mixed models in likelihood ratio tests.
}
\examples{
\dontrun{
fit.overall.rnd  <- ocmm(overall  ~ cycleno + bsa + treatment + (1|randno), data=ANZ0001)
anova(fit.overall.rnd, update(fit.overall.rnd, .~. + age))
}
}
\author{
Maurizio Manuguerra, Gillian Heller
}
\keyword{anova}
\keyword{summary,}

