% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dict.R
\name{ore.dict}
\alias{ore.dict}
\alias{ore_dict}
\title{Get or set entries in the pattern dictionary}
\usage{
ore.dict(..., enclos = parent.frame())
}
\arguments{
\item{...}{One or more strings or dictionary keys. Unnamed, literal strings
will be returned unmodified, named strings will be added to the
dictionary, and unquoted names will be resolved using the dictionary.}

\item{enclos}{Enclosure for resolving names not present in the dictionary.
Passed to \code{\link[base]{eval}}.}
}
\value{
If no arguments are provided, the whole dictionary is returned.
  Otherwise the return value is a (possibly named) character vector of
  resolved strings.
}
\description{
This function allows the user to get or set entries in the pattern
dictionary, a library of regular expressions whose elements can be referred
to by name in \code{\link{ore}}, and therefore easily reused.
}
\examples{
# Literal strings are returned as-is
ore.dict("protocol")

# Named arguments are added to the dictionary
ore.dict(protocol="\\\\w+://")

# ... and can be retrieved by name
ore.dict(protocol)

}
\seealso{
\code{\link{ore}}, which passes its arguments through this function
}

