% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transform.R
\name{reorient}
\alias{inverseReorient}
\alias{reorient}
\title{Reorient Image using NIfTI header}
\usage{
reorient(nim, data, verbose = FALSE, invert = FALSE, tol = 1e-07)

inverseReorient(nim, verbose = FALSE)
}
\arguments{
\item{nim}{is an object of class \code{nifti}.}

\item{data}{is an array associated with \code{nim}.}

\item{verbose}{is a logical variable (default = \code{FALSE}) that allows
text-based feedback during execution of the function.}

\item{invert}{stores the inverse transform.}

\item{tol}{is a very small value used to judge if a number is essentially
zero.}
}
\description{
Transforms in the NIfTI header are parsed and normalized
versions of these transforms are applied.
}
\details{
This function utilizes the \code{performPermutation} function
internally.
}
\author{
Andrew Thornton \email{zeripath@users.sourceforge.net},\cr
Brandon Whitcher \email{bwhitcher@gmail.com}
}
\seealso{
\code{\link{performPermutation}}
}

