% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/osm_delete_note.R
\name{osm_delete_note}
\alias{osm_delete_note}
\title{Delete notes}
\usage{
osm_delete_note(note_id, text)
}
\arguments{
\item{note_id}{Note ids represented by a numeric or a character vector.}

\item{text}{A non-mandatory comment as text.}
}
\value{
Returns a data frame with the hided map notes (same format as \code{\link[=osm_get_notes]{osm_get_notes()}} with \code{format = "R"}).
}
\description{
Hide (delete) notes. This request needs to be done as an authenticated user with moderator role.
}
\details{
Use \code{\link[=osm_reopen_note]{osm_reopen_note()}} to make the note visible again.
}
\examples{
\dontrun{
set_osmapi_connection("testing") # use the testing server
note <- osm_create_note(lat = "40.7327375", lon = "0.1702526", text = "Test note to delete.")
del_note <- osm_delete_note(note_id = note$id, text = "Hide note")
del_note
}
}
\seealso{
Other edit notes' functions: 
\code{\link{osm_close_note}()},
\code{\link{osm_create_comment_note}()},
\code{\link{osm_create_note}()}

Other functions for moderators: 
\code{\link{osm_hide_comment_changeset_discussion}()},
\code{\link{osm_redaction_object}()}
}
\concept{edit notes' functions}
\concept{functions for moderators}
