% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/osmapi_user_data.R
\name{osm_get_preferences_user}
\alias{osm_get_preferences_user}
\alias{osm_set_preferences_user}
\title{Get or set preferences for the logged-in user}
\usage{
osm_get_preferences_user(key, format = c("R", "xml", "json"))

osm_set_preferences_user(key, value, all_prefs)
}
\arguments{
\item{key}{Returns a string with this preference's value. If missing, return all preferences.}

\item{format}{Format of the output. Can be \code{"R"} (default), \code{"xml"}, or \code{"json"}. Only relevant when \code{key} is
missing.}

\item{value}{A string with the preference value to set for \code{key}. If \code{NULL}, deletes the \code{key} preference.}

\item{all_prefs}{A \code{data.frame}, \code{xml_document} or a json list following the format returned by
\code{osm_get_preferences_user()}. Also, a path to an xml file describing the user preferences.
\strong{All} existing preferences are replaced by the newly uploaded set.}
}
\value{
If \code{format = "R"}, returns a data frame with \code{key} and \code{value} columns of the user preferences.
\subsection{\code{format = "xml"}}{

Returns a \link[xml2:oldclass]{xml2::xml_document} with the following format:

\if{html}{\out{<div class="sourceCode xml">}}\preformatted{<osm version="0.6" generator="OpenStreetMap server">
  <preferences>
    <preference k="somekey" v="somevalue" />
    ...
  </preferences>
</osm>
}\if{html}{\out{</div>}}
}

\subsection{\code{format = "json"}}{

Returns a list with the following json structure:

\if{html}{\out{<div class="sourceCode json">}}\preformatted{\{
  "version": "0.6",
  "generator": "OpenStreetMap server",
  "preferences": \{"somekey": "somevalue, ...\}
\}
}\if{html}{\out{</div>}}
}

\subsection{Set preferences}{

Nothing is returned upon successful setting of user preferences.
}
}
\description{
Get or set preferences for the logged-in user
}
\details{
The sizes of the key and value are limited to 255 characters.

The OSM server supports storing arbitrary user preferences. This can be used by editors, for example, to offer the
same configuration wherever the user logs in, instead of a locally-stored configuration. For an overview of
applications using the preferences-API and which key-schemes they use, see
\href{https://wiki.openstreetmap.org/wiki/Preferences}{this wiki page}.
}
\examples{
\dontrun{
prefs_ori <- osm_get_preferences_user()
prefs_ori


osm_set_preferences_user(key = "osmapiR-test", value = "good!")
osm_get_preferences_user(key = "osmapiR-test")

osm_set_preferences_user(key = "osmapiR-test", value = NULL) # Delete pref

## Restore all preferences
osm_set_preferences_user(all_prefs = prefs_ori)
}
}
\seealso{
Other users' functions: 
\code{\link{osm_details_logged_user}()},
\code{\link{osm_get_user_details}()}
}
\concept{users' functions}
