/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.osmose.output;

import fr.ird.osmose.output.IOutput;
import fr.ird.osmose.util.SimulationLinker;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;

public abstract class AbstractOutput
extends SimulationLinker
implements IOutput {
    private FileOutputStream fos;
    private PrintWriter prw;
    private boolean cutoff;
    private int recordFrequency;
    private final String separator = this.getConfiguration().getOutputSeparator();

    abstract String getFilename();

    abstract String getDescription();

    abstract String[] getHeaders();

    AbstractOutput(int rank) {
        super(rank);
    }

    boolean includeClassZero() {
        return !this.cutoff;
    }

    @Override
    public void init() {
        this.cutoff = this.getConfiguration().getBoolean("output.cutoff.enabled");
        this.recordFrequency = this.getConfiguration().getInt("output.recordfrequency.ndt");
        File path = new File(this.getConfiguration().getOutputPathname());
        File file = new File(path, this.getFilename());
        boolean fileExists = file.exists();
        file.getParentFile().mkdirs();
        try {
            this.fos = new FileOutputStream(file, true);
        }
        catch (FileNotFoundException ex) {
            this.getSimulation().warning("Failed to create output file {0}.", file.getAbsolutePath());
        }
        this.prw = new PrintWriter(this.fos, true);
        if (!fileExists) {
            String[] headers;
            this.prw.println(this.quote(this.getDescription()));
            this.prw.print(this.quote("Time"));
            for (String header : headers = this.getHeaders()) {
                this.prw.print(this.separator);
                this.prw.print(this.quote(header));
            }
            this.prw.println();
        }
    }

    @Override
    public void close() {
        if (null != this.prw) {
            this.prw.close();
        }
        if (null != this.fos) {
            try {
                this.fos.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    void writeVariable(float time, double[] variable) {
        this.prw.print(time);
        for (int i = 0; i < variable.length; ++i) {
            this.prw.print(this.separator);
            String sval = Float.isInfinite((float)variable[i]) ? "Inf" : Float.toString((float)variable[i]);
            this.prw.print(sval);
        }
        this.prw.println();
    }

    void writeVariable(float time, double[][] variable) {
        for (double[] row : variable) {
            this.prw.print(time);
            for (int j = 0; j < row.length; ++j) {
                this.prw.print(this.separator);
                String sval = Float.isInfinite((float)row[j]) ? "Inf" : Float.toString((float)row[j]);
                this.prw.print(sval);
            }
            this.prw.println();
        }
    }

    public int getRecordFrequency() {
        return this.recordFrequency;
    }

    @Override
    public boolean isTimeToWrite(int iStepSimu) {
        return (iStepSimu + 1) % this.recordFrequency == 0;
    }

    public String quote(String str) {
        return "\"" + str + "\"";
    }

    public String[] quote(String[] str) {
        String[] arr = new String[str.length];
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = this.quote(str[i]);
        }
        return arr;
    }
}

