% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add-osm-surface.R
\name{list2df_with_data}
\alias{list2df_with_data}
\title{list2df_with_data}
\usage{
list2df_with_data(map, xy, dat, bg, grid_size = 100, method = "idw")
}
\arguments{
\item{map}{A ggplot2 object (used only to obtain plot limits)}

\item{xy}{List of coordinates of spatial objects}

\item{dat}{A data surface (which may be irregular) used to provide the
z-values for the resultant data frame.}

\item{bg}{background colour from 'add_osm_surface()', passed here only to
confirm whether it is given or missing}

\item{grid_size}{Size of interpolation grid as taken from 'add_osm_surface()'}

\item{method}{Either 'idw' (Inverse Distance Weighting as spatstat::idw;
default), otherwise uses 'Gaussian' for kernel smoothing (as
spatstat::Smooth.ppp)}
}
\value{
A single data frame of object IDs, coordinates, and z-values
}
\description{
Converts a list of spatial objects to a single data frame, and adds a
corresponding 'z' column provided by mapping mean object coordinates onto a
spatially interpolated version of 'dat'
}

