test_that("meter, counter", {
  mp <- meter_provider_memory_new()
  on.exit(mp$shutdown(), add = TRUE)
  mtr <- mp$get_meter()
  expect_true(mtr$is_enabled())
  ctr <- mtr$create_counter("ctr")
  ctr$add(1)
  ctr$add(10)
  mp$flush()
  mp$shutdown()
  mrcs <- mp$get_metrics()
  md <- mrcs[[2]][["scope_metric_data"]][[1]][["metric_data"]][[1]]
  expect_equal(md[["instrument_name"]], "ctr")
  expect_equal(md[["instrument_type"]], "counter")
  expect_equal(md[["instrument_value_type"]], "double")
  expect_equal(md[["point_data_attr"]][[1]][["value"]][["value"]], 11)
})

test_that("meter, up_down_counter", {
  mp <- meter_provider_memory_new()
  on.exit(mp$shutdown(), add = TRUE)
  mtr <- mp$get_meter()
  udc <- mtr$create_up_down_counter("udctr")
  udc$add(1)
  udc$add(10)
  mp$flush()
  mp$shutdown()
  mrcs <- mp$get_metrics()
  md <- mrcs[[2]][["scope_metric_data"]][[1]][["metric_data"]][[1]]
  expect_equal(md[["instrument_name"]], "udctr")
  expect_equal(md[["instrument_type"]], "up_down_counter")
  expect_equal(md[["instrument_value_type"]], "double")
  expect_equal(md[["point_data_attr"]][[1]][["value"]][["value"]], 11)
})

test_that("meter, histogram", {
  skip("unreliable")
  mp <- meter_provider_memory_new()
  on.exit(mp$shutdown(), add = TRUE)
  mtr <- mp$get_meter()
  hst <- mtr$create_histogram("hst")
  hst$record(1)
  hst$record(10)
  mp$flush()
  mp$shutdown()
  mrcs <- mp$get_metrics()
  md <- mrcs[[2]][["scope_metric_data"]][[1]][["metric_data"]][[1]]
  expect_equal(md[["instrument_name"]], "hst")
  expect_equal(md[["instrument_type"]], "histogram")
  expect_equal(md[["instrument_value_type"]], "double")
  expect_equal(md[["point_data_attr"]][[1]][["value"]][["sum"]], 11)
  expect_equal(md[["point_data_attr"]][[1]][["value"]][["min"]], 1)
  expect_equal(md[["point_data_attr"]][[1]][["value"]][["max"]], 10)
  expect_equal(md[["point_data_attr"]][[1]][["value"]][["count"]], 2)
})

test_that("meter, gauge", {
  mp <- meter_provider_memory_new()
  on.exit(mp$shutdown(), add = TRUE)
  mtr <- mp$get_meter()
  udc <- mtr$create_gauge("gge")
  udc$record(1)
  udc$record(10)
  mp$flush()
  mp$shutdown()
  mrcs <- mp$get_metrics()
  md <- mrcs[[2]][["scope_metric_data"]][[1]][["metric_data"]][[1]]
  expect_equal(md[["instrument_name"]], "gge")
  expect_equal(md[["instrument_type"]], "gauge")
  expect_equal(md[["instrument_value_type"]], "double")
  expect_equal(md[["point_data_attr"]][[1]][["value"]][["value"]], 10)
})

test_that("meter_new when metrics are disabled", {
  fake(meter_new, "find_instrumentation_scope", list(on = FALSE, name = "nm"))
  mtr <- meter_new("name")
  expect_s3_class(mtr, "otel_meter_noop")
})
