% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitting.R
\name{obfit}
\alias{obfit}
\title{Outerbase model fit}
\usage{
obfit(
  x,
  y,
  numb = 100,
  verbose = 0,
  covnames = NULL,
  hyp = NULL,
  numberopts = 2,
  nthreads = NULL
)
}
\arguments{
\item{x}{a n by d sized matrix of inputs}

\item{y}{a n length vector of outputs}

\item{numb}{size of basis to use}

\item{verbose}{0-3, how much information on optimization to print to console}

\item{covnames}{a d length vector of covariance names}

\item{hyp}{initial covariance hyperparameters}

\item{numberopts}{number of optimizations done for hyperparameters, must be
larger than 1}

\item{nthreads}{number of threads used in learning}
}
\value{
Saving important model information to be used with 
\code{\link{obpred}}
}
\description{
This function fits an outerbase model for prediction and hides most of the
actual object-oriented aspects of the package.
}
