% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_table.R
\name{get_table}
\alias{get_table}
\title{Get specified table from OxCOVID19 Database}
\usage{
get_table(con, tbl_name)
}
\arguments{
\item{con}{Connection to OxCOVID19 Database. This can be specified using
the \code{connect_oxcovid19} function.}

\item{tbl_name}{Name of table available in OxCOVID19 Database. Should be
one of the table names given by a call to \code{list_tables}.}
}
\value{
An RPostgres_tbl object of the specified OxCOVID19 Database table
}
\description{
Get specified table from OxCOVID19 Database
}
\examples{
con <- connect_oxcovid19()
get_table(con = con, tbl_name = "epidemiology")

}
\author{
Ernest Guevarra
}
