% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/edm_crit.R
\name{edm_crit}
\alias{edm_crit}
\title{Distance in measure criterion}
\usage{
edm_crit(
  x,
  integration.points,
  integration.weights = NULL,
  intpoints.oldmean,
  intpoints.oldsd,
  precalc.data,
  model,
  threshold,
  batchsize,
  alpha,
  current.crit
)
}
\arguments{
\item{x}{vector of dimension \eqn{d} representing the \eqn{ith} point where to compute the criterion}

\item{integration.points}{p*d matrix of points for numerical integration in the X space.}

\item{integration.weights}{Vector of size p corresponding to the weights of these integration points.}

\item{intpoints.oldmean}{Vector of size p corresponding to the kriging mean at the integration points.}

\item{intpoints.oldsd}{Vector of size p corresponding to the kriging standard deviation at the integration points.}

\item{precalc.data}{list result of \link[KrigInv]{precomputeUpdateData} with \code{model} and \code{x}.}

\item{model}{km model}

\item{threshold}{threshold selected for excursion set}

\item{batchsize}{number of simulation points}

\item{alpha}{value of Vorob'ev threshold}

\item{current.crit}{Current value of the criterion}
}
\value{
the value of the expected distance in measure criterion at \eqn{x}
}
\description{
Computes the distance in measure criterion.
}
\references{
Azzimonti D. F., Bect J., Chevalier C. and Ginsbourger D. (2016). Quantifying uncertainties on excursion sets under a Gaussian random field prior. SIAM/ASA Journal on Uncertainty Quantification, 4(1):850–874.

Azzimonti, D. (2016). Contributions to Bayesian set estimation relying on random field priors. PhD thesis, University of Bern.
}
