% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/p_search_any.R
\name{p_search_any}
\alias{p_sa}
\alias{p_search_any}
\title{Search CRAN Packages by Maintainer, Author, Version or Package}
\usage{
p_search_any(term, search.by = "Maintainer")

p_sa(term, search.by = "Maintainer")
}
\arguments{
\item{term}{A search term (character string).}

\item{search.by}{The variable to search by (takes 
a integer or a character string): 1-\code{"Maintainer"}, 
1-\code{"Author"}, 2-\code{"Package"}, 3-\code{"Version"}}
}
\description{
Uses \code{\link[base]{agrep}} to find packages by 
maintainer (often this is the author as well) or by name.
}
\details{
Useful for finding packages by the same author (usually the same as 
the maintainer).  This function will take some time as the function 
is searching thousands of packages via CRAN's website.
}
\examples{
\dontrun{
p_search_any("hadley", 1)
p_sa("hadley", "author")
p_sa("color", 2)
p_sa("psych", "package")
}
}
\author{
BondedDust (stackoverflow.com) and Tyler Rinker <tyler.rinker@gmail.com>
}
\references{
\url{http://cran.r-project.org/web/checks/check_summary_by_maintainer.html#summary_by_maintainer}
\url{http://stackoverflow.com/a/10082624/1000343}
}
\keyword{author}
\keyword{package}
\keyword{search}

