% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/residuals_paco.r
\name{residuals_paco}
\alias{residuals_paco}
\title{Return Procrustes residuals from a paco object}
\usage{
residuals_paco(object, type = "interaction")
}
\arguments{
\item{object}{An obejct of class \code{procrustes} as returned from PACo (and internally the \code{vegan::procrustes} function). In a PACo output this is \code{D$proc}.}

\item{type}{Character string. Whether the whole residual matrix (\code{matrix}) or the residuals per interaction (\code{interaction}) is desired.}
}
\value{
If \code{type=interaction}, a named vector of the Procrustes residuals is returned where names are the interactions. If \code{type=matrix}, a matrix of residuals from Procrustes superimposition is returned.
}
\description{
Takes the Procrustes object from \code{vegan::procrustes} of the global superimpostion and pulls out either the residual matrix of superimposition or the residual of each individual interaction (link between host and parasite).
}
\examples{
data(gopherlice)
library(ape)
gdist <- cophenetic(gophertree)
ldist <- cophenetic(licetree)
D <- prepare_paco_data(gdist, ldist, gl_links)
D <- add_pcoord(D, correction='cailliez')
D <- PACo(D, nperm=100, seed=42, method='r0')
residuals_paco(D$proc)
}

