% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weather_summary.R
\name{pa_get_weather_sf}
\alias{pa_get_weather_sf}
\title{Downloads a met file using the apsimx package}
\usage{
pa_get_weather_sf(
  aoi,
  source = c("none", "iem", "power"),
  start.date = "1990-01-01",
  end.date = "2021-12-31"
)
}
\arguments{
\item{aoi}{a sf object}

\item{source}{the weather source from which the data
should be retrieved. \sQuote{iem} = Iowa Environmental
Mesonet, \sQuote{power} = NASA POWER. Defaults to
\sQuote{iem}.}

\item{start.date}{first day to retrieve the weather data.
Format should be \%Y-\%m-\%d.}

\item{end.date}{last day to retrieve the weather data.
Format should be \%Y-\%m-\%d.}
}
\value{
an object of class met
}
\description{
This function retrieves weather data from
NASA Power and the Iowa Environmental Mesonet using the
apsimx package/
}
\examples{
\donttest{
extd.dir <- system.file("extdata", package = "pacu")
area.of.interest <- sf::st_read(file.path(extd.dir, 'cobs_a_aoi.shp'))
weather.met <- pa_get_weather_sf(aoi = area.of.interest,
                               start.date = '1990-01-01',
                               end.date = '2020-12-31',
                               source = 'power')
}


}
\author{
Caio dos Santos and Fernando Miguez
}
